/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.util;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_4538;
import net.minecraft.class_5558;
import slimeknights.mantle.Mantle;

public class BlockEntityHelper {
    public static <T> Optional<T> get(Class<T> clazz, @Nullable class_1922 world, class_2338 pos) {
        return BlockEntityHelper.get(clazz, world, pos, false);
    }

    public static <T> Optional<T> get(Class<T> clazz, @Nullable class_1922 world, class_2338 pos, boolean logWrongType) {
        if (!BlockEntityHelper.isBlockLoaded(world, pos)) {
            return Optional.empty();
        }
        class_2586 tile = world.method_8321(pos);
        if (tile == null) {
            return Optional.empty();
        }
        if (clazz.isInstance(tile)) {
            return Optional.of(clazz.cast(tile));
        }
        if (logWrongType) {
            Mantle.logger.warn("Unexpected TileEntity class at {}, expected {}, but found: {}", (Object)pos, clazz, tile.getClass());
        }
        return Optional.empty();
    }

    public static boolean isBlockLoaded(@Nullable class_1922 world, class_2338 pos) {
        if (world == null) {
            return false;
        }
        if (world instanceof class_4538) {
            return ((class_4538)world).method_22340(pos);
        }
        return true;
    }

    @Nullable
    public static <HAVE extends class_2586, RET extends class_2586> class_5558<RET> castTicker(class_2591<RET> expected, class_2591<HAVE> have, class_5558<? super HAVE> ticker) {
        return have == expected ? ticker : null;
    }

    @Nullable
    public static <HAVE extends class_2586, RET extends class_2586> class_5558<RET> serverTicker(class_1937 level, class_2591<RET> expected, class_2591<HAVE> have, class_5558<? super HAVE> ticker) {
        return level.field_9236 ? null : BlockEntityHelper.castTicker(expected, have, ticker);
    }

    private BlockEntityHelper() {
    }
}

